
florida_tutorial = 0;

butterfly_offset = { x = 0, y = 0 }; -- global butterfly offset, offsets mesh and image position

butterfly_range = 
{
	{ 1, 33 }, -- module 1
	{ 34, 66 }, -- module 2
	{ 67, 99 }, -- module 3
};

butterfly_images = 
{
	-- 001 - 033
	"001",
	"002",
	"003",
	"004",
	"005",
	"006",
	"007",
	"008",
	"009",
	"010",
	"011",
	"012",
	"013",
	"014",
	"015",
	"016",
	"017",
	"018",
	"019",
	"020",
	"021",
	"022",
	"023",
	"024",
	"025",
	"026",
	"027",
	"028",
	"029",
	"030",
	"031",
	"032",
	"033",
	
	-- 034 - 066
	"001",
	"002",
	"003",
	"004",
	"005",
	"006",
	"007",
	"008",
	"009",
	"010",
	"011",
	"012",
	"013",
	"014",
	"015",
	"016",
	"017",
	"018",
	"019",
	"020",
	"021",
	"022",
	"023",
	"024",
	"025",
	"026",
	"027",
	"028",
	"029",
	"030",
	"031",
	"032",
	"033",
	
	-- 067 - 099
	"001",
	"002",
	"003",
	"004",
	"005",
	"006",
	"007",
	"008",
	"009",
	"010",
	"011",
	"012",
	"013",
	"014",
	"015",
	"016",
	"017",
	"018",
	"019",
	"020",
	"021",
	"022",
	"023",
	"024",
	"025",
	"026",
	"027",
	"028",
	"029",
	"030",
	"031",
	"032",
	"033",
}

function got_all_butterflies(module_num)
	local range_start = butterfly_range[module_num][1];
	local range_end = butterfly_range[module_num][2];
	local all_collected = true;
	local collected_count = 0;
	
	for i = range_start, range_end do
		local capturedString = string.format("captured_butterfly_%03d", i);
		if game:Get(capturedString) < 1 then
			all_collected = false;
			break;
		end
		collected_count = collected_count + 1;
	end
	
	return all_collected;
end

butterfly_completion_temp = 0;

function check_butterfly_completion()
	for i,v in butterfly_range do
		if not quest_complete("collect_butterflies" .. tostring(i)) then
			if got_all_butterflies(i) then
				butterfly_completion_temp = i;
				scene.FLO:StartProc(
					function(flo)
						flo:SetMode(MODE.CUTSCENE);
						run_super_conversation(flo, "quip_flo_general_O");
						complete_quest("collect_butterflies" .. tostring(butterfly_completion_temp));
						wait_subscene();
						game:Set( "butterflies_" .. tostring(butterfly_completion_temp), 1 );
						--debug_out(game:Get( "butterflies_1" ) .. " " .. game:Get( "butterflies_2" ) .. " " .. game:Get( "butterflies_3" ));
						if ( game:Get( "butterflies_1" ) == 1 and game:Get( "butterflies_2" ) == 1 and game:Get( "butterflies_3" ) == 1 ) then
							game:Set( "got_all_butterflies", 1 );
							game:EarnAward("avenue-flo_butterflies");
						end
						
						flo_after_napkin_prompt(flo);
						
						flo:SetMode(MODE.FOLLOWCLICKS);
					end
				);
			end
		end
	end
end

function no_butterfly_bag(flo)
	if florida_tutorial == 1 then
		game:Set("florida_tutorial", game:Get("florida_tutorial") + 1);
	end

	flo:SetMode(MODE.CUTSCENE);
	flo:StopWalking();
	run_super_conversation(flo, "quip_no_butterflybag");
	if game:Get("napkin_butterfly_bag") < 1 then
		add_quest("butterfly_bag");
		--wait_subscene();
	end	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

-- then pass to the spawn_butterflies function in the scene_setup as spawn_butterflies(butterfly_numbers)
function spawn_butterflies()
	
	if game:Get("got_butterflybag") == 1 then
		spawn_button(butterflybag_spec);
	end
	
	local butterfly_spawn_list = scene:Spawn
	{
		name = "BUTTERFLY_SPAWN_LIST";
		
		command = function(actor)
			actor.spawnlist = {};
		end;
	};
	
	for h,u in pairs(butterfly_numbers) do
		if tostring(h) == game:GetCurrentScene() then
			for i,v in pairs(u) do
				if game:Get("captured_butterfly_" .. tostring(v)) ~= 1 then -- only spawn butterflies that haven't been captured
					local butterfly = scene:Spawn
					{
						name = "BUTTERFLY_" .. v;
						halo = "quest/butterflies/" .. butterfly_images[tonumber(v)];
						gfx = { anim = "anim/butterflies/butterflies_" .. butterfly_images[tonumber(v)] };
						hotspot = { x = butterfly_offset.x, y = butterfly_offset.y };
						
						command = function(actor)
							--actor:SetDepthMode(DEPTH.DEPTH_FRONTMOST);
							actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
							actor:JumpToNamedPoint("butterfly_" .. v);
							actor:JumpToPoint{ x = actor:GetPosition().x-butterfly_offset.x, y = actor:GetPosition().y-butterfly_offset.y };
							actor:ModifySaySpec { color = { a = 1.0, r = 1.0, g = 0.5, b = 0.125 } };
							actor:SetWalkSpeed(20);
							actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
							actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
							actor:PlayAnim("Still");
							
							actor.capturedString = "captured_butterfly_" .. v;
							
							if game:Get("florida_tutorial") < 1 then
								florida_tutorial = 1;
							end
							
							actor.on_click = function(flo, butterfly)
								if game:Get("got_butterflybag") == 1 then
									game:Set(butterfly.capturedString, 1); -- mark captured so doesn't spawn again
									game:Set("butterfly_count", game:Get("butterfly_count") + 1);
									butterfly:StartProc(butterfly_flytobag);
								else
									flo:StartProc(no_butterfly_bag);
								end
								return RESPONSE.IGNORE;
							end;
						end;
					};
					
					table.insert(butterfly_spawn_list.spawnlist, butterfly);
				end
			end
		end
	end
	
	butterfly_spawn_list:StartProc(cycle_flapping_butterflies);
end

function cycle_flapping_butterflies(actor)
	while true do
		delay(300);
		local butterflycount = table.getn(actor.spawnlist);
		
		if butterflycount == 0 then
			actor:Expire();
		else
			local butterflynum = math.random(1, butterflycount);
			actor.spawnlist[butterflynum]:PlayAnim("Flap");
		end
	end
end

function butterfly_flytobag(butterfly)
	scene.FLO:SetMode(MODE.CUTSCENE);
	butterfly:SetDepthMode(DEPTH.DEPTH_OVER_HUD);
	local position = butterfly:GetScreenPosition();
	local desiredpos = scene.BUTTERFLYBAG:GetPosition();
	local moveTime = 0.88*SECOND_DELAY; -- synch to sound
	local timer = 0;
	
	for i,v in pairs(scene.BUTTERFLY_SPAWN_LIST.spawnlist) do
		if v == butterfly then
			table.remove(scene.BUTTERFLY_SPAWN_LIST.spawnlist, i);
			break;
		end
	end
	
	sfx:PlaySFX("audio/sfx/butterfly_pickup");
	butterfly:PlayAnim("Flapping");
	
	while timer < moveTime do
		local newPoint = { x = 0, y = 0 };
		local delta = timer / moveTime;
		
		newPoint.x = position.x + ((desiredpos.x - position.x) * delta);
		newPoint.y = position.y + ((desiredpos.y - position.y) * delta);
		butterfly:JumpToPoint(newPoint);
		timer = timer + 1;
		delay(1);
	end
	
	--butterfly:SetPosition(butterfly:GetScreenPosition());
	
	--butterfly:WalkToXY(scene.BUTTERFLYBAG:GetPosition());
	--wait_walkto();
	
	scene.BUTTERFLYBAG:SayRaw(tostring(game:Get("butterfly_count")));
	butterfly:Expire();
	
	scene.FLO:SetMode(MODE.FOLLOWCLICKS);
	
	if florida_tutorial == 1 then
		game:Set("florida_tutorial", game:Get("florida_tutorial") + 1);
	end
	
	MET_Count("ButterfliesCollected");
	
	check_butterfly_completion();
end
